<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Repositories\Eloquent\Admin\CarRepository;
use App\Http\Requests\Admin\CarRequests\CarStoreRequest;
use App\Http\Requests\Admin\CarRequests\CarUpdateRequest;

class CarController extends Controller
{

    public $cars;

    public function __construct(CarRepository $cars)
    {
        $this->cars = $cars;
    }

    public function index($offset, $limit)
    {
        try{
            $cars = $this->cars->index($offset, $limit);
            return view('admin.cars.index', compact('cars'));
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function create()
    {
        return $this->cars->create();
    }

    public function store(CarStoreRequest $request)
    {
        try{
            $this->cars->store($request);
            flash()->success('Success');
            return back();
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function edit($id)
    {
        return $this->cars->edit($id);
    }

    public function update(CarUpdateRequest $request, $id)
    {
        try{
            $this->cars->update($request, $id);
            flash()->success('Success');
            return back();
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function activate(Request $request)
    {
        try{
            $this->cars->activate($request->record_id);
            flash()->success('Success');
            return back();
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function delete(Request $request)
    {
        try{
            $this->cars->delete($request->record_id);
            flash()->success('Success');
            return back();
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function search(Request $request)
    {
        return $this->cars->search($request);
    }

    public function searchByColumn(Request $request)
    {
        return $this->cars->searchByColumn($request);
    }

    public function pagination($offset, $limit)
    {
        return $this->cars->pagination($offset, $limit);
    }

    public function archives($offset, $limit)
    {
        return $this->cars->archivesPage($offset, $limit);
    }

    public function archivesPagination($offset, $limit)
    {
        return $this->cars->archives($offset, $limit);
    }

    public function archivesSearch(Request $request)
    {
        return $this->cars->archivesSearch($request);
    }

    public function archivesSearchByColumn(Request $request)
    {
        return $this->cars->archivesSearchByColumn($request);
    }


    public function back(Request $request)
    {
        try{
            $this->cars->back($request->record_id);
            flash()->success('Success');
            return back();
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function orders($offset, $limit)
    {
        try{
            $orders = $this->cars->orders($offset, $limit);
            return view('admin.cars.orders', compact('orders'));
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

}