<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Repositories\Eloquent\Admin\DestinationRepository;
use App\Http\Requests\Admin\DestinationRequests\DestinationStoreRequest;
use App\Http\Requests\Admin\DestinationRequests\DestinationUpdateRequest;

class DestinationController extends Controller
{

    public $destinations;

    public function __construct(DestinationRepository $destinations)
    {
        $this->destinations = $destinations;
    }

    public function index($offset, $limit)
    {
        try{
            $destinations = $this->destinations->index($offset, $limit);
            return view('admin.destinations.index', compact('destinations'));
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function create()
    {
        return $this->destinations->create();
    }

    public function store(DestinationStoreRequest $request)
    {
        try{
            $this->destinations->store($request);
            flash()->success('Success');
            return back();
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function edit($id)
    {
        return $this->destinations->edit($id);
    }

    public function update(DestinationUpdateRequest $request, $id)
    {
        try{
            $this->destinations->update($request, $id);
            flash()->success('Success');
            return back();
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function activate(Request $request)
    {
        try{
            $this->destinations->activate($request->record_id);
            flash()->success('Success');
            return back();
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function delete(Request $request)
    {
        try{
            $this->destinations->delete($request->record_id);
            flash()->success('Success');
            return back();
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function search(Request $request)
    {
        return $this->destinations->search($request);
    }

    public function searchByColumn(Request $request)
    {
        return $this->destinations->searchByColumn($request);
    }

    public function pagination($offset, $limit)
    {
        return $this->destinations->pagination($offset, $limit);
    }

    public function archives($offset, $limit)
    {
        return $this->destinations->archivesPage($offset, $limit);
    }

    public function archivesPagination($offset, $limit)
    {
        return $this->destinations->archives($offset, $limit);
    }

    public function archivesSearch(Request $request)
    {
        return $this->destinations->archivesSearch($request);
    }

    public function archivesSearchByColumn(Request $request)
    {
        return $this->destinations->archivesSearchByColumn($request);
    }


    public function back(Request $request)
    {
        try{
            $this->destinations->back($request->record_id);
            flash()->success('Success');
            return back();
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function uploadAlbums(Request $request, $id)
    {
        try{
            return $this->destinations->uploadAlbums($request, $id);
        }catch(\Exception $e){
            // return response()->json(['error' => $e], 400);
            return response()->json(['error' => 'There Is Something Wrong, Please Contact Technical Support'], 400);
        }
    }

    public function deleteImg(Request $request, $id)
    {
        try{
            $this->destinations->deleteImg($request, $id);
            flash()->success('Success');
            return back();
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

}