<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Repositories\Eloquent\Admin\RoomRepository;
use App\Http\Requests\Admin\RoomRequests\RoomStoreRequest;
use App\Http\Requests\Admin\RoomRequests\RoomUpdateRequest;
use App\Models\Hotel;
use App\Models\Room;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;

class RoomController extends Controller
{

    public $hotel;
    public $room;
    public $roomRepository;

    public function __construct(
        Hotel $hotel, Room $room, RoomRepository $roomRepository,
    ){
        $this->hotel = $hotel;
        $this->room = $room;
        $this->roomRepository = $roomRepository;
        $this->middleware('auth:api', ['except' => ['details']]);
    }

    public function details($id)
    {
        $record = $this->room->where('id', $id)->with(['hotel', 'room_type', 'options'])->first();
        return responseJson(200, "success", $record);
    }

    public function store(RoomStoreRequest $request)
    {
        $auth = auth()->user();
        $hotel = $this->hotel->where('id', $request->hotel_id)->where('owner_id', $auth->id)->first();
        if ($hotel) {
            try{
                $this->roomRepository->store($request);
                return responseJson(200, "success");
            }catch(\Exception $e){
                return responseJson(404, "There is something wrong , please contact technical support");
            }
        }else{
            return responseJson(404, "Not Found");
        }
    }

    public function update(RoomUpdateRequest $request, $id)
    {
        $auth = auth()->user();
        $hotel = $this->hotel->where('id', $request->hotel_id)->where('owner_id', $auth->id)->first();
        if ($hotel) {
            try{
                $this->roomRepository->update($request, $id);
                return responseJson(200, "success");
            }catch(\Exception $e){
                DB::rollBack();
                return responseJson(404, "There is something wrong , please contact technical support");
            }
        }else{
            return responseJson(404, "Not Found");
        }
    }

    public function activate($id)
    {
        $auth = auth()->user();
        $room = $this->room->where('id', $id)->with('hotel')->first();
        if ($room && $room->hotel && (int)$room->hotel?->owner_id == $auth->id) {
            try{
                $this->roomRepository->activate($id);
                return responseJson(200, "success");
            }catch(\Exception $e){
                return responseJson(404, "There is something wrong , please contact technical support");
            }
        }
        return responseJson(404, "Not Found");
    }

}
