<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Requests\Api\CafeRequesrs\StoreCafeOrderRequest;
use App\Models\ChatGroup;
use Illuminate\Http\Request;
use App\Models\Wallet;
use App\Models\WalletTransaction;
use App\Http\ServicesLayer\BarqServices\BarqService;
use App\Http\ServicesLayer\PaymobServices\PaymobService;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Validator;

class WalletController extends Controller
{

    public $wallet;
    public $walletTransaction;
    public $chatGroup;
    public $barqService;
    public $paymobService;

    public function __construct(Wallet $wallet, WalletTransaction $walletTransaction, ChatGroup $chatGroup, BarqService $barqService, PaymobService $paymobService)
    {
        $this->wallet = $wallet;
        $this->walletTransaction = $walletTransaction;
        $this->chatGroup = $chatGroup;
        $this->barqService = $barqService;
        $this->paymobService = $paymobService;
        $this->middleware('auth:api', ['except' => []]);
    }

    public function addWallet($typeable)
    {   
        $wallet = $typeable->wallet()->create([
            'created_at' => now(),
            'updated_at' => now(),
        ]);
        return $wallet;
    }
    
    public function deposit(Request $request)
    {
        
        $validator = Validator::make($request->all(), [
            'amount' => 'required|integer|min:1',
            'description' => 'nullable|string|max:255',
            'group_id' => 'nullable|exists:chat_groups,id',
        ]);
        if ($validator->fails()) {
            return responseJson(400, "Bad Request", $validator->errors());
        }

        try {

            DB::beginTransaction();
            $user = auth()->user();
            if (isset($request->group_id) && !is_null($request->group_id)) {
                $group = $this->chatGroup->where('id', $request->group_id)->active()->first();
                $wallet = $group->wallet;
                if(!$wallet){
                    $wallet = $this->addWallet($group); 
                }
            }else {
                // $wallet = $this->addWallet($user);
                $wallet = $user->wallet;
                if(!$wallet){
                    $wallet = $this->addWallet($user); 
                }
            }
            $transaction = $wallet->transactions()->create([
                'type' => 1, // deposit
                'status' => 0, // not compeleted
                'amount' => $request->amount,
                'description' => $request->description ?? null,
                'wallet_id' => $wallet->id,
                'user_id' => $user->id,
                'chat_group_id' => $request->group_id ?? null,
            ]);
            DB::commit();

            // paymob getway 
            $data['paymob_url'] = $this->paymobService->generatePaymentUrl($transaction->amount, $transaction->id, 0, $user);

            return responseJson(200, "success", $data);
        } catch (\Exception $e) {
            DB::rollBack();
            return responseJson(500, 'there is some thing wrong , please contact technical support');
        }
    }

    public function withdrow(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'amount' => 'required|integer|min:1',
            'description' => 'nullable|string|max:255',
            'group_id' => 'nullable|exists:chat_groups,id',
        ]);
        if ($validator->fails()) {
            return responseJson(400, "Bad Request", $validator->errors());
        }

        try {

            DB::beginTransaction();
            $user = auth()->user();
            if (isset($request->group_id) && !is_null($request->group_id)) {
                $typeable = $this->chatGroup->where('id', $request->group_id)->active()->first();
            }else {
                $typeable = $user;
            }

            $wallet = $typeable->wallet->load(['user_deposit_transactions', 'user_withdraw_transactions', 'user_withdraw_transactions_requests']);
            if(!$wallet) {
                return responseJson(500, 'there is some thing wrong , please contact technical support');
            }
            $deposit_transactions_amount = array_sum(array_column($wallet->user_deposit_transactions->toArray(), 'amount')) ?? 0;
            $withdraw_transactions_amount = array_sum(array_column($wallet->user_withdraw_transactions->toArray(), 'amount')) ?? 0;
            $userBalance = $deposit_transactions_amount - $withdraw_transactions_amount;
            if ($wallet->balance < $request->amount || $userBalance < $request->amount) {
                return responseJson(500, 'this amount less than in your wallet amount');
            }
            if (count($wallet->user_withdraw_transactions_requests) > 0) {
                return responseJson(500, 'You have already withdrawal requests, please wait for them to complete the process.');
            }
            
            $wallet->transactions()->create([
                'type' => 2, // withdrow
                'status' => 0, // not compeleted
                'amount' => $request->amount,
                'description' => $request->description ?? null,
                'wallet_id' => $wallet->id,
                'user_id' => $user->id,
                'chat_group_id' => $request->group_id ?? null,
            ]);
            DB::commit();

            return responseJson(200, "success");
        } catch (\Exception $e) {
            DB::rollBack();
            return responseJson(500, 'there is some thing wrong , please contact technical support');
        }
    }

    public function barqCallback(Request $request)
    {

        $providerId = data_get($request->all(), 'id') ?? null;
        $status = data_get($request->all(), 'status'); // success | failed | pending
        $userID = data_get($request->all(), 'metadata.user_id');
        $groupID = data_get($request->all(), 'metadata.group_id');
        $transactionID = data_get($request->all(), 'metadata.transaction_id');

        $transaction = $this->walletTransaction->where('id', $transactionID)->where('group_id', $groupID)->where('user_id', $userID)->first();
        if (!$transaction) {
            Log::warning('Callback without local transaction', $request->all());
            return responseJson(404, "error", ['message' => "Not Found"]);
        }
        if ((int)$transaction->status === 1) {
            return responseJson(200, "success", ['message' => 'success']);
        }

        try {
            if ($status === 'success') {
                
                DB::beginTransaction();
                $transaction->update([
                    'status' => 1,  // completed
                    'provider_id' => $providerId,
                ]);

                $wallet = $transaction->wallet()->lockForUpdate()->first();
                if ((int)$transaction->type === 1) {
                    $wallet->balance = $wallet->balance + (float)$transaction->amount;
                }elseif ((int)$transaction->type === 2) {
                    $wallet->balance = $wallet->balance - (float)$transaction->amount;
                }
                $wallet->save();
                DB::commit();
            }
        } catch (\Throwable $th) {
            DB::rollBack();
        }

        return responseJson(200, "success", ['message' => 'success']);
    }

}
