<?php

namespace App\Http\Requests\Api\CarRequesrs;

use Illuminate\Foundation\Http\FormRequest;

class StoreCarOrderRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'chat_group_id' => 'nullable|exists:chat_groups,id',
            'trip_id' => 'nullable|exists:trips,id',
            'car_id' => 'required|exists:cars,id',
            'day' => 'required|date_format:Y-m-d',
            'time' => 'required|date_format:H:i',
            'current_location' => 'required|string|max:1255',
            'destination' => 'required|string|max:1255',
        ];
    }
}
