<?php

namespace App\Http\Requests\Api\HotelRequesrs;

use Illuminate\Foundation\Http\FormRequest;

class StoreHotelOrderRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'chat_group_id' => 'nullable|exists:chat_groups,id',
            'trip_id' => 'nullable|exists:trips,id',
            'hotel_id' => 'required|exists:hotels,id',
            'date_arrive' => 'required|date_format:Y-m-d',
            'date_departure' => 'required|date_format:Y-m-d',
            'time_arrive' => 'required|date_format:H:i',
            'time_departure' => 'required|date_format:H:i',
            'room_id' => 'required|exists:rooms,id',
            // 'room' => 'required|string|max:255',
            'persons_count' => 'required|integer|min:1',
            'children_count' => 'required|integer|min:0',
        ];
    }
}