<?php 

namespace App\Http\ServicesLayer\BarqServices;

use Illuminate\Support\Facades\Http;

class BarqService
{
    protected $apiKey;
    protected $baseUrl;

    public function __construct()
    {
        $this->apiKey  = config('services.barq.api_key');
        $this->baseUrl = config('services.barq.base_url');
    }

    public function createShipment(array $data)
    {
        return Http::withToken($this->apiKey)->post($this->baseUrl . '/v1/shipments', $data)->json();
    }

    public function trackShipment($trackingNumber)
    {
        return Http::withToken($this->apiKey)->get($this->baseUrl . "/v1/shipments/{$trackingNumber}")->json();
    }
}
