<?php

namespace App\Http\ServicesLayer\PaymobServices;

use App\Http\Repositories\Eloquent\Admin\WalletRepository;
use App\Models\payment;
use App\Models\Wallet;
use App\Models\WalletTransaction;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Str;

class PaymobService 
{
    public $wallet;
    public $walletTransaction;
    public $walletRepository;

    public $apiKey;
    public $iframeURL;
    public $hmacSecret;
    public $publicKey;
    public $secretKey;
    public $integrationID;

    protected array $hmacOrder = [
        'amount_cents', 'created_at', 'currency', 'error_occured', 'has_parent_transaction', 'id',
        'integration_id', 'is_3d_secure', 'is_auth', 'is_capture', 'is_refunded', 'is_standalone_payment',
        'is_voided', 'order', 'owner', 'pending', 'source_data_pan', 'source_data_sub_type',
        'source_data_type', 'success',
    ];

    public function __construct()
    {
        $this->wallet = new Wallet();
        $this->walletTransaction = new WalletTransaction();
        $this->walletRepository = new WalletRepository();
        
        // $this->publicKey = env('PAYMOB_PUBLIC_KEY_LIVE');
        // $this->secretKey = env('PAYMOB_SECRET_KEY_LIVE');
        // $this->integrationID = env('PAYMOB_INTEGRATION_ID_LIVE');
        // $this->publicKey = env('PAYMOB_PUBLIC_KEY_TEST');
        // $this->secretKey = env('PAYMOB_SECRET_KEY_TEST');
        // $this->integrationID = env('PAYMOB_INTEGRATION_ID_TEST');

        // $this->apiKey = env('PAYMOB_API_KEY');
        // $this->iframeURL = env('PAYMOB_IFRAME_ID');
        // $this->hmacSecret = (string)env('PAYMOB_HMAC_SECRET');
        
        $this->publicKey = "sau_pk_test_Fo0WWrzdHkADzY1CUK6GV2ZrhOt4An5X";
        $this->secretKey = "sau_sk_test_1b54d41bc50800fd86e3a146916334c6ca81e91f1facb8dd7662cb6397bde649";
        $this->integrationID = 14841;

        $this->apiKey = "ZXlKaGJHY2lPaUpJVXpVeE1pSXNJblI1Y0NJNklrcFhWQ0o5LmV5SmpiR0Z6Y3lJNklrMWxjbU5vWVc1MElpd2ljSEp2Wm1sc1pWOXdheUk2TVRBNU9URXNJbTVoYldVaU9pSnBibWwwYVdGc0luMC5SZHMzMWNKeWlQZXduX0R5SmlDN1FUVFVSek5acU12LWdBd1hBWjh3N0JqcnhkZUdoc2pscXJCekxlY1ZoZzViaG5MX2htRVZPaGNTSWl3S0tlanA4Zw==";
        $this->iframeURL = 9897;
        $this->hmacSecret = (string)"0DEF3BFFB73DDBAAE5D8BB8B5349C336";
    }

    public function generatePaymentUrl(int $amountCents, int $transactionID, int $transactionType, $user)
    {
        
        $specialReference = Str::upper(Str::random(5)) . '-' . $transactionID;
        $payload = [
            "amount"          => $amountCents,
            "currency"        => "SAR",
            "expiration"      => 3600,
            "order_id"        => (string)$transactionID,
            "payment_methods" => [(int)$this->integrationID],
            "items" => [[
                "name"        => "Order #{$transactionID}",
                "amount"      => $amountCents,
                "description" => "Cart items",
                "quantity"    => 1,
            ]],
            "billing_data" => [
                "first_name"  => $user->name ?? 'guest',
                "last_name"   => $user->name ?? 'guest',
                "email"       => $user->email ?? 'guest@example.com',
                "phone_number"=> $user->phone ?? '0000000000',
                "apartment"   => "",
                "street"      => "",
                "building"    => "",
                "country"     => "",
                "floor"       => "",
                "state"       => "",
            ],
            "special_reference" => $specialReference,
            "customer" => [
                "first_name"  => $user->name ?? 'guest',
                "last_name"   => $user->name ?? 'guest',
                "email"       => $user->email ?? 'guest@example.com',
                "extras"      => ["source" => "laravel"],
            ],
            "extras" => [
                "transaction_id" => $transactionID,
                "transaction_type" => $transactionType,
            ],
        ];

        try {
            $res = Http::withHeaders([
                'Authorization' => "Token {$this->secretKey}",
                'Content-Type'  => "application/json",
            ])->post('https://ksa.paymob.com/v1/intention/', $payload);
            // ])->post('https://accept.paymob.com/v1/intention/', $payload);

            if (!$res->successful()) {
                throw new \RuntimeException('Paymob intention failed: ' . $res->body());
            }

            $clientSecret = $res->json('client_secret');
            if (!$clientSecret) {
                throw new \RuntimeException('Missing client_secret in intentions response');
            }

            return "https://ksa.paymob.com/unifiedcheckout/?publicKey={$this->publicKey}&clientSecret={$clientSecret}";
        } catch (\Exception $e) {
            report($e);
            return 0;
        }
    }

    public function callback(Request $request)
    {

        [$valid, $payload] = $this->verifyHmac($request);
        if (!$valid) {
            return responseJson(400, 'Invalid HMAC');
        }

        $isSuccess = filter_var(($payload['success'] ?? $request->input('success')), FILTER_VALIDATE_BOOLEAN);
        if (!$isSuccess) {
            return responseJson(400, 'Not Success');
        }
        
        $transactionID = implode('-', $payload['merchant_order_id'])[1];
        // report('request callback ====================> ' . $request);
        // dd($payload, $request->all(), $transactionID);

        $txId = (string)($payload['id'] ?? $request->input('id'));
        $subType = $payload['source_data_sub_type'] ?? $request->input('source_data_sub_type');

        return $this->markPaid($transactionID, $subType, $txId);
    }

    public function webhook(Request $request)
    {
        [$valid, $payload] = $this->verifyHmac($request);

        if (!$valid) {
            return responseJson(400, 'Invalid HMAC');
        }

        $isSuccess  = filter_var(($payload['success'] ?? false), FILTER_VALIDATE_BOOLEAN);
        $isVoided   = filter_var(($payload['is_voided'] ?? false), FILTER_VALIDATE_BOOLEAN);
        $isRefunded = filter_var(($payload['is_refunded'] ?? false), FILTER_VALIDATE_BOOLEAN);

        if ($isSuccess && !$isVoided && !$isRefunded) {

            $transactionID = explode('-', $payload['merchant_order_id'])[1];
            // report('request webhook ====================> ' . $request);
            // dd($payload, $request->all(), $transactionID);

            $txId = (string)($payload['id'] ?? '');
            $subType = $payload['source_data_sub_type'] ?? null;

            return $this->markPaid($transactionID, $subType, $txId);
        }

        return responseJson(200, 'Ignored');
    }

    public function verifyHmac(Request $request): array
    {
        $payload = $request->input('obj', $request->all());
        $sentHmac = $request->input('hmac', $payload['hmac'] ?? null);

        $concatenated = $this->buildHmacString($payload);
        $calculated = hash_hmac('sha512', $concatenated, $this->hmacSecret);

        $isValid = $sentHmac && hash_equals($calculated, $sentHmac);

        return [$isValid, $payload, $calculated, $sentHmac];
    }

    protected function buildHmacString(array $payload): string
    {
        $connected = '';
        foreach ($this->hmacOrder as $key) {
            $connected .= isset($payload[$key]) ? (string)$payload[$key] : '';
        }
        return $connected;
    }

    public function markPaid(?int $transactionID, ?string $subType, ?string $getwayTransactionID)
    {
        if (!$transactionID || !$getwayTransactionID) {
            return responseJson(422, 'Missing payment id');
        }

        $transaction = $this->walletTransaction->find($transactionID);
        if (!$transaction) {
            return responseJson(404, 'Payment not found');
        }
        if ($transaction->status == 0) {
            $this->walletRepository->calcPoints($transaction);
        }

        $transaction->update([
            'status' => 1,
            'payment_method_types' => $subType,
            'getway_transaction_id' => $getwayTransactionID,
        ]);
        $this->walletRepository->updateBalance($transaction->wallet_id);

        return responseJson(200, 'Thank You');
    }

}