@extends('layouts.admin.home')

<!-- title page -->
@section('title')
    <title>Destinations</title>
@endsection

<!-- custom css -->
@section('css')
@endsection

@section('content')

    <div class="page-content">
        <div class="container-fluid">

            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent" style="direction: ltr;">
                        {{-- <h4 class="mb-sm-0">Team</h4> --}}

                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"></li>
                                <li class="breadcrumb-item"><a href="{{route('admin/index')}}">Home</a></li>
                                <li class="breadcrumb-item active"><a href="{{route('admin/destinations/index')}}/0/{{PAGINATION_COUNT}}">Destinations</a></li>
                                <li class="active" style="color: var(--vz-breadcrumb-item-active-color);">Create</li>
                            </ol>
                        </div>

                    </div>
                </div>
            </div>

            @include('flash::message')
            @if ($errors->any())
                <div style="text-align: left; margin: 15px;">
                    <ul dir="ltr">
                        @foreach ($errors->all() as $error)
                            <li class="text-danger">{{$error}}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-header align-items-center d-flex">
                            <h4 class="card-title mb-0 flex-grow-1">Destination Form</h4>
                        </div>
                        <div class="card-body">
                            <form role="form" action="{{url(route('admin/destinations/create'))}}" method="post" enctype="multipart/form-data">
                                <div class="live-preview">
                                    @csrf
                                    <div class="row gy-4">


                                        <div class="card mt-xxl-n5">
                                            <div class="card-header">
                                                <ul class="nav nav-tabs card-header-tabs" role="tablist">
                                                    <li class="nav-item">
                                                        <a class="nav-link active fw-bold" data-bs-toggle="tab" href="#enLang" role="tab" style="border-width: 4px;">
                                                            <span class="text-danger">*</span> البيانات الاساسيه (EN)
                                                        </a>
                                                    </li>
                                                    <li class="nav-item">
                                                        <a class="nav-link fw-bold" data-bs-toggle="tab" href="#arLang" role="tab" style="border-width: 4px;">
                                                            AR
                                                        </a>
                                                    </li>
                                                    <li class="nav-item">
                                                        <a class="nav-link fw-bold" data-bs-toggle="tab" href="#frLang" role="tab" style="border-width: 4px;">
                                                            FR
                                                        </a>
                                                    </li>
                                                    <li class="nav-item">
                                                        <a class="nav-link fw-bold" data-bs-toggle="tab" href="#trLang" role="tab" style="border-width: 4px;">
                                                            TR
                                                        </a>
                                                    </li>
                                                    <li class="nav-item">
                                                        <a class="nav-link fw-bold" data-bs-toggle="tab" href="#hiLang" role="tab" style="border-width: 4px;">
                                                            HI
                                                        </a>
                                                    </li>
                                                </ul>
                                            </div>
                                        

                                            <div class="card-body p-4">
                                                <div class="tab-content">
                                                    
                                                    <div class="tab-pane active" id="enLang" role="tabpanel">
                                                        <div class="row">
                                                            <div class="col-xxl-6 col-md-6 mb-3">
                                                                <div class="group-form">
                                                                    <label for="namefloatingInput">name en <span class="text-danger">*</span></label>
                                                                    <input name="name[en]" type="text" class="form-control" id="namefloatingInput" placeholder="name en">
                                                                </div>
                                                            </div>
                                                            <div class="col-xxl-6 col-md-6 mb-3">
                                                                <div class="group-form">
                                                                    <label for="infofloatingInput">info en <span class="text-danger">*</span></label>
                                                                    <input name="info[en]" type="text" class="form-control" id="infofloatingInput" placeholder="info en">
                                                                </div>
                                                            </div>
                                                            <div class="col-xxl-6 col-md-6 mb-3">
                                                                <div class="group-form">
                                                                    <label for="locationfloatingInput">location en <span class="text-danger">*</span></label>
                                                                    <input name="location[en]" type="text" class="form-control" id="locationfloatingInput" placeholder="location en">
                                                                </div>
                                                            </div>
                                                            <div class="col-xxl-6 col-md-6 mb-3"></div>
                                                            
                                                            <div class="col-xxl-6 col-md-6">
                                                                <div class="form-group">
                                                                    <label style="margin-bottom: 7px;" for="">المالك <span class="text-danger">*</span></label><br/>
                                                                    <select name="owner_id" id="users" class="form-control">
                                                                        <option value="">---</option>
                                                                    </select>
                                                                </div>
                                                            </div>
                                                            <div class="col-xxl-6 col-md-6 mb-3">
                                                                <div class="group-form">
                                                                    <label for="map_locationfloatingInput">map location <span class="text-danger">*</span></label>
                                                                    <input name="map_location" type="text" class="form-control" id="map_locationfloatingInput" placeholder="map location">
                                                                </div>
                                                            </div>
                                                            <div class="col-xxl-6 col-md-6 mb-3">
                                                                <div class="group-form">
                                                                    <label for="filefloatingInput">img <span class="text-danger">*</span></label>
                                                                    <input name="file" type="file" id="filefloatingInput" class="form-control" placeholder="Upload Image">
                                                                </div>
                                                            </div> 
                                                            <div class="col-xxl-6 col-md-6 mb-3">
                                                                <div class="group-form">
                                                                    <label for="day_pricefloatingInput">day price <span class="text-danger">*</span></label>
                                                                    <input name="day_price" type="number" class="form-control" id="day_pricefloatingInput" placeholder="day price">
                                                                </div>
                                                            </div>
                                                            {{-- <div class="col-xxl-6 col-md-6 mb-3">
                                                                <div class="group-form">
                                                                    <label for="offerfloatingInput">offer <span class="text-danger"></span></label>
                                                                    <input name="offer" type="number" class="form-control" id="offerfloatingInput" placeholder="offer">
                                                                </div>
                                                            </div> --}}
                                                            <div class="col-xxl-6 col-md-6">
                                                                <div class="form-group">
                                                                    <label style="margin-bottom: 7px;" for="">الدوله <span class="text-danger">*</span></label><br/>
                                                                    <select name="country_id" id="countries" class="form-control">
                                                                        <option value="">---</option>
                                                                    </select>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    
                                                    <!--end tab-pane-->
                                                    <div class="tab-pane" id="arLang" role="tabpanel">
                                                        <div class="row g-2">
                                                            <div class="col-xxl-6 col-md-6 mb-3">
                                                                <div class="group-form">
                                                                    <label for="namefloatingInput">name ar <span class="text-danger"></span></label>
                                                                    <input name="name[ar]" type="text" class="form-control" id="namefloatingInput" placeholder="name ar">
                                                                </div>
                                                            </div>
                                                            <div class="col-xxl-6 col-md-6 mb-3">
                                                                <div class="group-form">
                                                                    <label for="infofloatingInput">info ar <span class="text-danger"></span></label>
                                                                    <input name="info[ar]" type="text" class="form-control" id="infofloatingInput" placeholder="info ar">
                                                                </div>
                                                            </div>
                                                            <div class="col-xxl-6 col-md-6 mb-3">
                                                                <div class="group-form">
                                                                    <label for="locationfloatingInput">location ar <span class="text-danger"></span></label>
                                                                    <input name="location[ar]" type="text" class="form-control" id="locationfloatingInput" placeholder="location ar">
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    
                                                    <!--end tab-pane-->
                                                    <div class="tab-pane" id="frLang" role="tabpanel">
                                                        <div class="row g-2">
                                                            <div class="col-xxl-6 col-md-6 mb-3">
                                                                <div class="group-form">
                                                                    <label for="namefloatingInput">name fr <span class="text-danger"></span></label>
                                                                    <input name="name[fr]" type="text" class="form-control" id="namefloatingInput" placeholder="name ar">
                                                                </div>
                                                            </div>
                                                            <div class="col-xxl-6 col-md-6 mb-3">
                                                                <div class="group-form">
                                                                    <label for="infofloatingInput">info fr <span class="text-danger"></span></label>
                                                                    <input name="info[fr]" type="text" class="form-control" id="infofloatingInput" placeholder="info fr">
                                                                </div>
                                                            </div>
                                                            <div class="col-xxl-6 col-md-6 mb-3">
                                                                <div class="group-form">
                                                                    <label for="locationfloatingInput">location fr <span class="text-danger"></span></label>
                                                                    <input name="location[fr]" type="text" class="form-control" id="locationfloatingInput" placeholder="location fr">
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    
                                                    <!--end tab-pane-->
                                                    <div class="tab-pane" id="trLang" role="tabpanel">
                                                        <div class="row g-2">
                                                            <div class="col-xxl-6 col-md-6 mb-3">
                                                                <div class="group-form">
                                                                    <label for="namefloatingInput">name tr <span class="text-danger"></span></label>
                                                                    <input name="name[tr]" type="text" class="form-control" id="namefloatingInput" placeholder="name ar">
                                                                </div>
                                                            </div>
                                                            <div class="col-xxl-6 col-md-6 mb-3">
                                                                <div class="group-form">
                                                                    <label for="infofloatingInput">info tr <span class="text-danger"></span></label>
                                                                    <input name="info[tr]" type="text" class="form-control" id="infofloatingInput" placeholder="info tr">
                                                                </div>
                                                            </div>
                                                            <div class="col-xxl-6 col-md-6 mb-3">
                                                                <div class="group-form">
                                                                    <label for="locationfloatingInput">location tr <span class="text-danger"></span></label>
                                                                    <input name="location[tr]" type="text" class="form-control" id="locationfloatingInput" placeholder="location tr">
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    
                                                    <!--end tab-pane-->
                                                    <div class="tab-pane" id="hiLang" role="tabpanel">
                                                        <div class="row g-2">
                                                            <div class="col-xxl-6 col-md-6 mb-3">
                                                                <div class="group-form">
                                                                    <label for="namefloatingInput">name hi <span class="text-danger"></span></label>
                                                                    <input name="name[hi]" type="text" class="form-control" id="namefloatingInput" placeholder="name ar">
                                                                </div>
                                                            </div>
                                                            <div class="col-xxl-6 col-md-6 mb-3">
                                                                <div class="group-form">
                                                                    <label for="infofloatingInput">info hi <span class="text-danger"></span></label>
                                                                    <input name="info[hi]" type="text" class="form-control" id="infofloatingInput" placeholder="info hi">
                                                                </div>
                                                            </div>
                                                            <div class="col-xxl-6 col-md-6 mb-3">
                                                                <div class="group-form">
                                                                    <label for="locationfloatingInput">location hi <span class="text-danger"></span></label>
                                                                    <input name="location[hi]" type="text" class="form-control" id="locationfloatingInput" placeholder="location hi">
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>

                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-12">
                                            <button class="btn btn-primary" type="submit">Submit form</button>
                                            <button class="btn btn-success" type="reset">Reset Button</button>
                                        </div>

                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>

@endsection

<!-- custom js -->
@section('script')
<script>
    (function () {
        $('.nav-link.menu-link').removeClass('active');
        $('.menu-dropdown').removeClass('show');
        $('.sidebardestinations').addClass('active');
        var target = $('.sidebardestinations').attr('href');
        $(target).addClass('show');
    })();
    $('#countries').select2({
        ajax: {
            url: "{{ route('get/countries') }}",
            dataType: 'json',
            processResults: function (data) {
                return {
                    results:  $.map(data, function (item) {
                        return {
                            id: item.id,
                            text: item.name
                        }
                    })
                };
            },
            cache: true,
            width: '100%'
        }
    });
    $('#users').select2({
        ajax: {
            url: "{{ route('get/users') }}",
            dataType: 'json',
            processResults: function (data) {
                return {
                    results:  $.map(data, function (item) {
                        return {
                            id: item.id,
                            text: item.name
                        }
                    })
                };
            },
            cache: true,
            width: '100%'
        }
    });
</script>
@endsection
