@extends('layouts.admin.home')

<!-- title page -->
@section('title')
    <title>Rooms</title>
@endsection

<!-- custom css -->
@section('css')
@endsection

@section('content')

    <div class="page-content">
        <div class="container-fluid">

            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent" style="direction: ltr;">
                        {{-- <h4 class="mb-sm-0">Team</h4> --}}

                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"></li>
                                <li class="breadcrumb-item"><a href="{{route('admin/index')}}">Home</a></li>
                                <li class="breadcrumb-item active"><a href="{{route('admin/rooms/index')}}/0/{{PAGINATION_COUNT}}">Rooms</a></li>
                                <li class="active" style="color: var(--vz-breadcrumb-item-active-color);">Update</li>
                            </ol>
                        </div>

                    </div>
                </div>
            </div>

            @include('flash::message')
            @if ($errors->any())
                <div style="text-align: left; margin: 15px;">
                    <ul dir="ltr">
                        @foreach ($errors->all() as $error)
                            <li class="text-danger">{{$error}}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-header align-items-center d-flex">
                            <h4 class="card-title mb-0 flex-grow-1">Room Update</h4>
                        </div>
                        <div class="card-body">
                            @isset($room)
                                <form role="form" action="{{url(route('admin/rooms/update', $room->id))}}" method="post" enctype="multipart/form-data">
                                    <div class="live-preview">
                                        @csrf
                                        <div class="row gy-4">

                                            <div class="col-xxl-6 col-md-6 mb-3">
                                                <div class="group-form">
                                                    <label for="infofloatingInput">info EN <span class="text-danger">*</span></label>
                                                    <input name="info[en]" value="{{ $room->translate('en')->info ?? '' }}" type="text" class="form-control" id="infofloatingInput" placeholder="info en">
                                                </div>
                                            </div>
                                            <div class="col-xxl-6 col-md-6 mb-3">
                                                <div class="group-form">
                                                    <label for="infofloatingInput">info AR <span class="text-danger">*</span></label>
                                                    <input name="info[ar]" value="{{ $room->translate('ar')->info ?? '' }}" type="text" class="form-control" id="infofloatingInput" placeholder="info ar">
                                                </div>
                                            </div>
                                            <div class="col-xxl-6 col-md-6 mb-3">
                                                <div class="group-form">
                                                    <label for="infofloatingInput">info FR <span class="text-danger">*</span></label>
                                                    <input name="info[fr]" value="{{ $room->translate('fr')->info ?? '' }}" type="text" class="form-control" id="infofloatingInput" placeholder="info fr">
                                                </div>
                                            </div>
                                            <div class="col-xxl-6 col-md-6 mb-3">
                                                <div class="group-form">
                                                    <label for="infofloatingInput">info TR <span class="text-danger">*</span></label>
                                                    <input name="info[tr]" value="{{ $room->translate('tr')->info ?? '' }}" type="text" class="form-control" id="infofloatingInput" placeholder="info tr">
                                                </div>
                                            </div>
                                            <div class="col-xxl-6 col-md-6 mb-3">
                                                <div class="group-form">
                                                    <label for="infofloatingInput">info HI <span class="text-danger">*</span></label>
                                                    <input name="info[hi]" value="{{ $room->translate('hi')->info ?? '' }}" type="text" class="form-control" id="infofloatingInput" placeholder="info hi">
                                                </div>
                                            </div>
                                            <div class="col-xxl-12 col-md-12 mb-3"></div>

                                            <div class="col-xxl-6 col-md-6">
                                                <div class="form-group">
                                                    <label style="margin-bottom: 7px;" for="">Hotel <span class="text-danger">*</span></label><br/>
                                                    <select name="hotel_id" id="hotels" class="form-control">
                                                        <option value="{{$room->hotel_id}}">{{$room->hotel?->name}}</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-xxl-6 col-md-6">
                                                <div class="form-group">
                                                    <label style="margin-bottom: 7px;" for="">Room Type <span class="text-danger">*</span></label><br/>
                                                    <select name="room_type_id" id="room_types" class="form-control">
                                                        <option value="{{$room->room_type_id}}">{{$room->room_type?->name}}</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-xxl-6 col-md-6">
                                                <div class="form-floating">
                                                    <input name="price" value="{{$room->price}}" type="text" class="form-control" id="pricefloatingInput" placeholder="price">
                                                    <label for="pricefloatingInput">price <span class="text-danger">*</span></label>
                                                </div>
                                            </div>
                                            <div class="col-xxl-6 col-md-6">
                                                <div class="form-floating">
                                                    <input name="file" type="file" id="filefloatingInput" class="form-control" placeholder="Upload Image">
                                                    <label for="filefloatingInput"><span class="text-danger"></span></label>
                                                </div>
                                            </div>
                                            <div class="col-xxl-6 col-md-6">
                                                <div class="form-floating">
                                                    <input name="room_count" value="{{$room->room_count}}" type="number" class="form-control" id="roomcountfloatingInput" placeholder="roomcount">
                                                    <label for="roomcountfloatingInput">room count <span class="text-danger">*</span></label>
                                                </div>
                                            </div>
                                            <div class="col-xxl-6 col-md-6">
                                                <div class="form-floating">
                                                    <input name="person_count" value="{{$room->person_count}}" type="number" class="form-control" id="personcountfloatingInput" placeholder="personcount">
                                                    <label for="personcountfloatingInput">person count <span class="text-danger">*</span></label>
                                                </div>
                                            </div>

                                            
                                            <div class="tab-pane" id="options" role="tabpanel">
                                                <div class="row g-2">
                                                    <div class="col-xxl-12 col-md-12">
                                                        <button class="btn btn-primary mb-1" id="add-input-options" type="button" style="background: #2f6bb9;"><i class="bx bx-plus"></i> Options</button>
                                                    </div>
                                                    @if($room->options)
                                                        @foreach ($room->options as $index => $option)
                                                            <div class="col-xxl-12 col-md-6">
                                                                <div class="col-xxl-6 col-md-6">
                                                                    <div id="options-area">
                                                                        <div class="input-container mb-1">
                                                                            <div class="row">
                                                                                <div class="col-xxl-10 col-md-10">
                                                                                    <div class="form-group">
                                                                                        <label style="margin-bottom: 7px;" for="">Option <span class="text-danger">*</span></label><br/>
                                                                                        <select name="options[]" id="" class="form-control options">
                                                                                            <option value="{{ $option->id }}">{{ $option->name }}</option>
                                                                                        </select>
                                                                                    </div>
                                                                                </div>
                                                                                <div class="col-xxl-2 col-md-2">
                                                                                    <label for="" class="mb-2"></label>
                                                                                    <span class="remove-btn badge bg-danger rounded-pill mt-4" parent-class="input-container-{{ $index }}}"><i class="bx bx-trash"></i></span>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        @endforeach
                                                    @else
                                                        <div class="col-xxl-12 col-md-12">
                                                            <div class="col-xxl-6 col-md-6">
                                                                <div id="options-area">
                                                                    <div class="input-container mb-1">
                                                                        <div class="row">
                                                                            <div class="col-xxl-10 col-md-10">
                                                                                <div class="form-group">
                                                                                    <label style="margin-bottom: 7px;" for="">Option <span class="text-danger">*</span></label><br/>
                                                                                    <select name="options[]" id="" class="form-control options">
                                                                                        <option value="">---</option>
                                                                                    </select>
                                                                                </div>
                                                                            </div>
                                                                            <div class="col-xxl-2 col-md-2">
                                                                                <label for="" class="mb-2"></label>
                                                                                <span class="remove-btn badge bg-danger rounded-pill mt-4" parent-class="input-container-0"><i class="bx bx-trash"></i></span>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    @endif
                                                </div>
                                            </div>

                                            <div class="col-12">
                                                <button class="btn btn-primary" type="submit">Submit form</button>
                                            </div>

                                        </div>
                                    </div>
                                </form>
                            @endisset
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>

@endsection

<!-- custom js -->
@section('script')
<script>
    (function () {
        $('.nav-link.menu-link').removeClass('active');
        $('.menu-dropdown').removeClass('show');
        $('.sidebarrooms').addClass('active');
        var target = $('.sidebarrooms').attr('href');
        $(target).addClass('show');
    })();
    $('#hotels').select2({
        ajax: {
            url: "{{ route('get/hotels') }}",
            dataType: 'json',
            processResults: function (data) {
                return {
                    results:  $.map(data, function (item) {
                        return {
                            id: item.id,
                            text: item.name
                        }
                    })
                };
            },
            cache: true
        }
    });
    $('#room_types').select2({
        ajax: {
            url: "{{ route('get/roomtypes') }}",
            dataType: 'json',
            processResults: function (data) {
                return {
                    results:  $.map(data, function (item) {
                        return {
                            id: item.id,
                            text: item.name
                        }
                    })
                };
            },
            cache: true
        }
    });
    $('.options').select2({
        ajax: {
            url: "{{ route('get/options') }}",
            dataType: 'json',
            processResults: function (data) {
                return {
                    results:  $.map(data, function (item) {
                        return {
                            id: item.id,
                            text: item.name
                        }
                    })
                };
            },
            cache: true
        }
    });
    
    let inputCount = 1000000000;
    $('#add-input-options').click(function () {

        inputCount++;
        $('#options-area').append(`
            <div class="input-container input-container-${inputCount} mb-1">
                <div class="row">
                    <div class="col-xxl-10 col-md-10">
                        <div class="form-group">
                            <label style="margin-bottom: 7px;" for="">Option <span class="text-danger">*</span></label><br/>
                            <select name="options[]" id="" class="form-control options">
                                <option value="">---</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-xxl-2 col-md-2">
                        <label for="" class="mb-2"></label>
                        <span class="remove-btn badge bg-danger rounded-pill mt-4" parent-class="input-container-${inputCount}"><i class="bx bx-trash"></i></span>
                    </div>
                </div>
            </div>
        `);
        $(`.options`).select2({
            ajax: {
                url: "{{ route('get/options') }}",
                dataType: 'json',
                processResults: function (data) {
                    return {
                        results:  $.map(data, function (item) {
                            return {
                                id: item.id,
                                text: item.name
                            }
                        })
                    };
                },
                cache: true
            }
        });
    });  
    $(document).on('click', '.remove-btn', function () {
        var parentClass = $(this).attr('parent-class');
        $('.'+parentClass).remove();
    });
</script>
@endsection
